<?php

namespace App\Livewire\Settings;

use App\Models\ReceiptSetting as ModelsReceiptSetting;
use App\Models\RestaurantTax;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class ReceiptSetting extends Component
{
    use LivewireAlert;
    public $settings;
    public bool $customerName;
    public bool $customerAddress;
    public bool $tableNumber;
    public bool $paymentQrCode;
    public bool $waiter;
    public bool $totalGuest;
    public bool $restaurantLogo;
    public $receiptSetting;
    public bool $restaurantTax;
    public bool $showTax;

    public function mount()
    {
        $this->receiptSetting = restaurant()->receiptSetting;
        $this->customerName = (bool)$this->receiptSetting->show_customer_name;
        $this->customerAddress = (bool)$this->receiptSetting->show_customer_address;
        $this->tableNumber = (bool)$this->receiptSetting->show_table_number;
        $this->paymentQrCode = (bool)$this->receiptSetting->show_payment_qr_code;
        $this->waiter = (bool)$this->receiptSetting->show_waiter;
        $this->totalGuest = (bool)$this->receiptSetting->show_total_guest;
        $this->restaurantLogo = (bool) $this->receiptSetting->show_restaurant_logo;
        $this->restaurantTax = (bool) $this->receiptSetting->show_tax;
    }


    public function submitForm()
    {
        $this->receiptSetting->update([
            'show_customer_name' => $this->customerName,
            'show_customer_address' => $this->customerAddress,
            'show_table_number' => $this->tableNumber,
            'show_payment_qr_code' => $this->paymentQrCode,
            'show_waiter' => $this->waiter,
            'show_total_guest' => $this->totalGuest,
            'show_restaurant_logo' => $this->restaurantLogo,
            'show_tax' => $this->restaurantTax,
        ]);

        $this->dispatch('settingsUpdated');

        $this->alert('success', __('messages.settingsUpdated'), [
            'toast' => true,
            'position' => 'top-end',
            'showCancelButton' => false,
            'cancelButtonText' => __('app.close')
        ]);
    }

    public function render()
    {
        return view('livewire.settings.receipt-setting');
    }

}
